<?php

function echoResponse ( $status_code, $data ) {

    $app = \Slim\Slim::getInstance();
    $response = $app->response();

    $response->status($status_code);
    $response->header('Content-Type', 'application/json');
    $response->body(json_encode(($data)));
    
}






// Verifing Params
function verifyRequiredParams ( $required_fields ) {

    $error = false;
    $error_fields = "";
    $request_params = $_REQUEST;

    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
        $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }

    foreach ($required_fields as $field) {
        
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {

        $response = array();
        $app = \Slim\Slim::getInstance();

        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoResponse(400, $response);
        $app->stop();
    }
}



       